import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/data/controller/cash_in/cash_in_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_close_button.dart';

class cashInWalletBottomSheet extends StatelessWidget {
  const cashInWalletBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CashInController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Align(
            alignment: Alignment.topCenter,
            child: Container(
              height: 5,
              width: 50,
              padding: const EdgeInsets.all(1),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: MyColor.colorGrey.withOpacity(0.1),
              ),
            ),
          ),
          const Row(
            mainAxisAlignment: MainAxisAlignment.end,
            children: [BottomSheetCloseButton()],
          ),
        ],
      ),
    );
  }
}
